% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaDflF.R
\docType{data}
\name{lFxegaDfGene}
\alias{lFxegaDfGene}
\title{Generate local functions and objects}
\format{
An object of class \code{list} of length 30.
}
\usage{
lFxegaDfGene
}
\description{
\code{lFxegaDfGene} is 
             the list of functions containing
             a definition of all local objects required for the use
             of evaluation functions. We reference this object 
             as local configuration. When adding additional 
             functions, this list must be extended
             by the constant (functions) needed to configure them.
}
\details{
We use the local configuration for: 
   \enumerate{
   \item
      Replacing all constants with constant functions.
      
      Rationale: We need one formal argument (the local function list lF)
      and we can dispatch multiple functions. E.g.  \code{lF$verbose()}
  \item    
      We can dynamically bind a local function with a definition from a
      proper function factory. E.g., the selection methods 
      \code{lf$SelectGene} and \code{lF$SelectMate}.
      
 \item Gene representations require special functions to handle them:
       \code{lf$InitGene}, \code{lF$DecodeGene}, \code{lf$EvalGene}
       \code{lf$ReplicateGene}, ...
      
 }
}
\seealso{
Other Configuration: 
\code{\link{xegaDfCrossoverFactory}()},
\code{\link{xegaDfGeneMapFactory}()},
\code{\link{xegaDfMutationFactory}()},
\code{\link{xegaDfReplicationFactory}()},
\code{\link{xegaDfScaleFactorFactory}()}
}
\concept{Configuration}
\keyword{datasets}
