\name{CellStyle}
\alias{CellStyle}
\alias{CellStyle.default}
\alias{setCellStyle}
\alias{getCellStyle}
\alias{is.CellStyle}
\title{Functions to manipulate cells.}
\description{
Create and set cell styles. 
}
\usage{

\method{CellStyle}{default}(wb, dataFormat=NULL, alignment=NULL,
  border=NULL, fill=NULL, font=NULL, cellProtection=NULL)

setCellStyle(cell, cellStyle)

getCellStyle(cell)

is.CellStyle(x)

}
\arguments{
  \item{wb}{a workbook object as returned by
    \code{\link{createWorkbook}} or \code{\link{loadWorkbook}}.}
  
  \item{dataFormat}{a \code{\link{DataFormat}} object.}
			
  \item{alignment}{a \code{\link{Alignment}} object.}
		       
  \item{border}{a \code{\link{Border}} object.}
  
  \item{fill}{a \code{\link{Fill}} object.}
			
  \item{font}{a \code{\link{Font}} object.}

  \item{cellProtection}{a \code{\link{CellProtection}} object.}
  
  \item{x}{a \code{CellStyle} object.}

  \item{cell}{a \code{\link{Cell}} object.}

  \item{cellStyle}{a \code{CellStyle} object.}

  \item{\ldots}{arguments to \code{CellStyle.default}.} 
  
  
}

\value{
  
  \code{createCellStyle} creates a CellStyle object.

  \code{is.CellStyle} returns \code{TRUE} if the argument is of class
  "CellStyle" and \code{FALSE} otherwise.
    
}
\details{
  \code{setCellStyle} sets the \code{CellStyle} to one \code{Cell}
  object.

  You need to have a \code{Workbook} object to attach  a
  \code{CellStyle} object to it.

  Since OS X 10.5 Apple dropped support for AWT on the main thread,  
  so essentially you cannot use any graphics classes in R on OS X 10.5  
  since R is single-threaded. (verbatim from Simon Urbanek).  This
  implies that setting colors on Mac will not work as is!  A set of
  about 50 basic colors are still available please see the javadocs. 

  For Excel 95/2000/XP/2003 the choice of colors is limited.  See
  \code{INDEXED_COLORS_} for the list of available colors.  
  
  Unspecified values for arguments are taken from the system locale.    
}
\author{Adrian Dragulescu}
\examples{
\dontrun{
  wb <- createWorkbook()
  sheet <- createSheet(wb, "Sheet1")

  rows  <- createRow(sheet, rowIndex=1)    

  cell.1 <- createCell(rows, colIndex=1)[[1,1]]     
  setCellValue(cell.1, "Hello R!")

  cs <- CellStyle(wb) +
    Font(wb, heightInPoints=20, isBold=TRUE, isItalic=TRUE,
      name="Courier New", color="orange") + 
    Fill(backgroundColor="lavender", foregroundColor="lavender",
      pattern="SOLID_FOREGROUND") +
    Alignment(h="ALIGN_RIGHT")
   
  setCellStyle(cell.1, cellStyle1)  

  # you need to save the workbook now if you want to see this art
}
}

