% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_set_global_opts.R
\name{set_style_path}
\alias{set_style_path}
\title{Set style sheet path}
\usage{
set_style_path(path = NULL)
}
\arguments{
\item{path}{the file path to the style sheet path (xlsx file). If NULL the function sets the cell format to the default option.}
}
\description{
Set the path to the style sheet to be used by package. To get this path see get_style_path.
Default cell formats used by xltabr is \href{https://github.com/moj-analytical-services/xltabr/blob/master/inst/extdata/styles.xlsx?raw=true}{here}.
If no path is supplied the function sets the style sheet to default.
}
\examples{
my_file_path <- system.file("extdata", "styles.xlsx", package = "xltabr")
set_style_path(my_file_path)
}
