% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_grid.R
\name{create_grid}
\alias{create_grid}
\title{Create a grid of values for tuning tskrr}
\usage{
create_grid(lim = c(1e-04, 10000), ngrid = 10)
}
\arguments{
\item{lim}{a numeric vector with 2 values giving the lower and upper limit
for the grid.}

\item{ngrid}{the number of values that have to be produced. If this
number is not integer, it is truncated. The value should be 2 or
larger.}
}
\value{
a numeric vector with values evenly spaced on a
logarithmic scale.
}
\description{
This function creates a grid of values for
tuning a \code{\link{tskrr}} model. The grid is equally spaced on
a logarithmic scale. Normally it's not needed to call this method
directly, it's usually called from \code{\link{tune}}.
}
\details{
The \code{lim} argument sets the boundaries of the domain in which
the lambdas are sought. The lambda values at which the function is
evaluated, are calculated as:

\code{exp(seq(log(1e-4), log(1e4), length.out = ngrid))}
}
\examples{
create_grid(lim = c(1e-4, 1), ngrid = 5)

}
\seealso{
\code{\link{tune}} for tuning a tskrr model.
}
