% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format.R
\name{xportr_format}
\alias{xportr_format}
\title{Assign SAS Format}
\usage{
xportr_format(
  .df,
  metacore,
  domain = NULL,
  verbose = getOption("xportr.format_verbose", "none")
)
}
\arguments{
\item{.df}{A data frame of CDISC standard.}

\item{metacore}{A data frame containing variable level metadata.}

\item{domain}{A character value to subset the \code{.df}. If \code{NULL}(default), uses
\code{.df} value as a subset condition.}

\item{verbose}{The action the function takes when a variable label isn't.
found. Options are 'stop', 'warn', 'message', and 'none'}
}
\value{
Data frame with \code{SASformat} attributes for each variable.
}
\description{
Assigns a SAS format from a variable level metadata to a given data frame.
}
\examples{
adsl <- data.frame(
  USUBJID = c(1001, 1002, 1003),
  BRTHDT = c(1, 1, 2)
)

metacore <- data.frame(
  dataset = c("adsl", "adsl"),
  variable = c("USUBJID", "BRTHDT"),
  format = c(NA, "DATE9.")
)

adsl <- xportr_format(adsl, metacore)
}
\seealso{
\code{\link[=xportr_label]{xportr_label()}}, \code{\link[=xportr_df_label]{xportr_df_label()}} and \code{\link[=xportr_length]{xportr_length()}}

Other metadata functions: 
\code{\link{xportr_df_label}()},
\code{\link{xportr_label}()},
\code{\link{xportr_length}()}
}
\concept{metadata functions}
