# Xpose 4
# An R-based population pharmacokinetic/
# pharmacodynamic model building aid for NONMEM.
# Copyright (C) 1998-2004 E. Niclas Jonsson and Mats Karlsson.
# Copyright (C) 2005-2008 Andrew C. Hooker, Justin J. Wilkins, 
# Mats O. Karlsson and E. Niclas Jonsson.
# Copyright (C) 2009-2010 Andrew C. Hooker, Mats O. Karlsson and 
# E. Niclas Jonsson.

# This file is a part of Xpose 4.
# Xpose 4 is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation, either version 3
# of the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.

# You should have received a copy of the GNU Lesser General Public License
# along with this program.  A copy can be cound in the R installation
# directory under \share\licenses. If not, see http://www.gnu.org/licenses/.

"reset.graph.par" <- function(object, classic=FALSE) {

  xpobj <- object

    rhome   <- R.home()
    xdefini <- paste(rhome, "\\library\\xpose4\\xpose.fac", sep="")

    # read global options
    if (is.readable.file(xdefini)) {
      xpobj <- xpose.read(object, file=xdefini)
    } else {
      cat("No factory settings found! Check that the file 'xpose.fac'\n")
      cat("is available and readable in your Xpose package root folder\n")
      cat(paste("(", xdefini, ").", sep=""))
      return(cat(""))
    }
  
  if (classic==TRUE) {
    assign(paste("xpdb", xpobj@Runno, sep = ""), xpobj, immediate=T, envir = .GlobalEnv)
    assign(pos = 1, ".cur.db", eval(as.name(paste("xpdb", xpobj@Runno, sep = ""))))
    return(cat(""))
  } else {
    return(xpobj)
  }

}
