% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module1_irt_utils.R
\name{irt_stats}
\alias{irt_rescale}
\alias{irt_sample}
\alias{irt_select}
\alias{irt_stats}
\title{IRT Utility Functions}
\usage{
irt_stats(x, stats = c("prob", "info", "lik", "loglik"), summary = NULL,
  fun = NULL, ...)

irt_select(x, people_index = NULL, item_index = NULL)

irt_sample(x, n.people = NULL, n.items = NULL)

irt_rescale(x, parameter = c("theta", "b"), mean = 0, sd = 1)
}
\arguments{
\item{x}{an IRT model object}

\item{stats}{the statistic to be computed}

\item{summary}{the summarization direction}

\item{fun}{the summarization function}

\item{...}{other optional arguments}

\item{people_index}{the indices of people to keep}

\item{item_index}{the indices of items to keep}

\item{n.people}{the number of people to sample}

\item{n.items}{the number of items to sample}

\item{parameter}{the rescaling parameter: 'theta' or 'b'}

\item{mean}{the mean of the new scale}

\item{sd}{the standard deviation of the new scale}
}
\description{
\code{irt_stats} provides a friendly interface to compute statistics

\code{irt_select} subsets data in an IRT model

\code{irt_sample} randomly samples data in an IRT model

\code{irt_rescale} rescales parameters in a 3PL model
}
\details{
In \code{irt_stats}, use \code{stats="prob"} to compute probability, 
\code{stats="info"} to compute information, \code{stats="lik"} to compute 
likelihood, and \code{stats="loglik"} to compute log-likelihood. 
Use \code{summary="people"} to summarize results over items and 
\code{summary="items"} to summarize results over people.\cr
}
\examples{
 
# Compute probability, information, likelihood and log-likelihood
x <- model_3pl()$gendata(20, 5)
irt_stats(x, "prob")
irt_stats(x, "prob", "people", sum)
irt_stats(x, "info")
irt_stats(x, "info", "items", sum)
irt_stats(x, "lik")
irt_stats(x, "loglik")
# subset
x <- model_3pl()$gendata(10, 5)
irt_select(x, people_index=c(1, 3, 5))
irt_select(x, item_index=c(1, 3, 5))
# sample wihtout replacement
irt_sample(x, n.people=3)
irt_sample(x, n.items=3)
# sample with replacement
irt_sample(x, n.people=30)
irt_sample(x, n.items=30)
# rescale theta
x <- model_3pl()$gendata(20, 5)
c(mean(x$people$theta), sd(x$people$theta))
y <- irt_rescale(x, "theta", 0, 1)
c(mean(y$people$theta), sd(y$people$theta))
round(abs(irt_stats(x, "prob") - irt_stats(y, "prob")), 2)
# rescale b
c(mean(x$items$b), sd(x$items$b))
y <- irt_rescale(x, "b", 0, 1)
c(mean(y$items$b), sd(y$items$b))
round(abs(irt_stats(x, "prob") - irt_stats(y, "prob")), 2)
}

