% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module5_mst_sim.R
\name{mst_sim}
\alias{mst_sim}
\alias{plot.mst.sim}
\alias{print.mst.sim}
\title{MST Simulation}
\usage{
mst_sim(x, true, rdp = NULL, ...)

\method{print}{mst.sim}(x, ...)

\method{plot}{mst.sim}(x, ...)
}
\arguments{
\item{x}{the assembled MST}

\item{true}{the true theta parameter}

\item{rdp}{a list of routing decision points}

\item{...}{additional option/control parameters}
}
\description{
\code{mst_sim} runs a MST simulation
}
\examples{
\dontrun{
set.seed(10001)
pool <- model_3pl()$gendata(1,200)$items
pool$content <- sample(1:3, nrow(pool), replace=TRUE)
pool$time <- round(rlnorm(nrow(pool), log(60), .2))
x <- mst(pool, "1-2", 2, 'topdown', len=20, maxselect=1)
x <- mst_obj(x, theta=-1, indices=1)
x <- mst_obj(x, theta= 1, indices=2)
x <- mst_constraint(x, "content", 10, 10, level=1)
x <- mst_stage_length(x, 1, min=5)
x <- mst_assemble(x, timeout=10)
rdp <- list(stage1=0)
mst_sim(x, 1.0, rdp)
}
}

