% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverageDataSet.R
\name{coverageDataSet}
\alias{coverageDataSet}
\title{Create a CoverageDataSet}
\usage{
coverageDataSet(bamfiles, annotations, types, sf = c(1, 1, 1, 1),
  paired_end = TRUE, as_fragments = TRUE)
}
\arguments{
\item{bamfiles}{A vector of characters indicating the BAM files paths.}

\item{annotations}{An object of type \code{\link{annotationsSet}}
containing information on genes.}

\item{types}{A vector of the same length as \code{bamfiles} indicating the type
of data in each file. Example: WT vs MUT or untreated vs treated".}

\item{sf}{A vector of the same length as \code{bamfiles} indicating the
scaling factor to apply on each file. Each coverage value is multiplied
by this factor before being reported. Useful for normalizing coverage
by, e.g., reads per million (RPM).}

\item{paired_end}{logical indicating whether the \code{bamfiles}
contains paired-end data.}

\item{as_fragments}{logical indicating if paired-end data must paired
and merged to form fragments.}
}
\value{
An object of class 'coverageDataSet' containing the coverage for each sample.
        The details of the output componets are as follow:

   \item{data}{ A \code{\link[data.table]{data.table}} with the following components:
     \describe{
       \item{chrom}{Gene chromosome.}
       \item{start}{Gene transcription start site.}
       \item{end}{Gene transcription termination site.}
       \item{name}{Gene name.}
       \item{score}{Gene score.}
       \item{strand}{Gene strand.}
       \item{pos}{One based positions of the gene.}
       \item{...}{For each sample, report the depth at each position of the gene per sample.}
     }}
   \item{samples}{A list containg the samples' names that are in the coverageDataSet.
    \describe{
       \item{type1}{Type1 samples names (controls)}
       \item{type2}{Type2 samples names (experiment)}
     }}
}
\description{
Create a CoverageDataSet containing the depth and breadth of coverage of genes in \code{annotations}.
}
\examples{
samples <- c("wt_rep1", "wt_rep2", "mut_rep1", "mut_rep2")
bamfiles <- system.file("extdata", paste0(samples, ".bam"),
                              package = "yCrypticRNAs")
data(annotations)
types <- c("wt", "wt", "mut", "mut")
scaling_factors <- c(0.069872847, 0.081113079, 0.088520251, 0.069911116)
rna_seq_signals <- coverageDataSet (bamfiles, annotations, types, scaling_factors)
rna_seq_signals
}

