% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proxy.R
\name{proxy.factor}
\alias{proxy.factor}
\title{Calculate Substitute Values for Factor Levels}
\usage{
\method{proxy}{factor}(x, y = as.numeric(x), ...)
}
\arguments{
\item{x}{factor}

\item{y}{factor or vector}

\item{...}{ignored}
}
\value{
same class as y
}
\description{
Calculates substitute values for factor levels.
If x and y have same length and there is a
one-to-one correspondence of their elements,
then unique elements of y are returned in
an order corresponding to levels(x).
}
\examples{
proxy(factor(1:3), letters[1:3])
proxy(factor(1:3), factor(letters[1:3]))
proxy(factor(letters[4:6]))
foo <- classified(letters[1:5])
as_yamlet(attributes(foo))
foo <- classified(foo, labels = proxy(foo))
as_yamlet(attributes(foo))
}
\seealso{
Other proxy: 
\code{\link{proxy}()}
}
\concept{proxy}
\keyword{internal}
