% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decorate.R
\name{decorate.data.frame}
\alias{decorate.data.frame}
\title{Decorate Data Frame}
\usage{
\method{decorate}{data.frame}(x, meta = NULL, ...)
}
\arguments{
\item{x}{data.frame}

\item{meta}{file path for corresponding yaml metadata, or a yamlet; an attempt will be made to guess the file path if x has a 'source' attribute}

\item{...}{passed to \code{\link{decorate.list}}}
}
\value{
class 'decorated' 'data.frame'
}
\description{
Decorates a data.frame. Expects metadata in yamlet
format, and loads it onto columns as attributes.
}
\examples{
library(csv)
file <- system.file(package = 'yamlet', 'extdata','quinidine.csv')
meta <- system.file(package = 'yamlet', 'extdata','quinidine.yaml')
a <- decorate(as.csv(file))
b <- decorate(as.csv(file), meta = as_yamlet(meta))
c <- decorate(as.csv(file), meta = meta)
d <- decorate(as.csv(file), meta = file)
e <- resolve(decorate(as.csv(file)))

# Most import methods are equivalent.
identical(a, b)
identical(a, c)
identical(a, d)
identical(a, e)
}
\seealso{
decorate.list

Other interface: 
\code{\link{as.data.frame.yamlet}()},
\code{\link{canonical.decorated}()},
\code{\link{classified.data.frame}()},
\code{\link{decorate.character}()},
\code{\link{desolve.decorated}()},
\code{\link{ggplot.decorated}()},
\code{\link{io_csv.character}()},
\code{\link{io_csv.data.frame}()},
\code{\link{io_res.character}()},
\code{\link{io_table.character}()},
\code{\link{io_table.data.frame}()},
\code{\link{io_yamlet.character}()},
\code{\link{io_yamlet.data.frame}()},
\code{\link{is_parseable.default}()},
\code{\link{mimic.default}()},
\code{\link{modify.default}()},
\code{\link{promote.list}()},
\code{\link{read_yamlet}()},
\code{\link{resolve.decorated}()},
\code{\link{selected.default}()},
\code{\link{write_yamlet}()}

Other decorate: 
\code{\link{as_decorated.default}()},
\code{\link{as_decorated}()},
\code{\link{decorate.character}()},
\code{\link{decorate.list}()},
\code{\link{decorate}()},
\code{\link{decorations.data.frame}()},
\code{\link{decorations}()},
\code{\link{redecorate}()}
}
\concept{decorate}
\concept{interface}
