% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/num-huber_loss.R
\name{huber_loss}
\alias{huber_loss}
\alias{huber_loss.data.frame}
\alias{huber_loss_vec}
\title{Huber loss}
\usage{
huber_loss(data, ...)

\method{huber_loss}{data.frame}(data, truth, estimate, delta = 1, na_rm = TRUE, ...)

huber_loss_vec(truth, estimate, delta = 1, na_rm = TRUE, ...)
}
\arguments{
\item{data}{A \code{data.frame} containing the \code{truth} and \code{estimate}
columns.}

\item{...}{Not currently used.}

\item{truth}{The column identifier for the true results
(that is \code{numeric}). This should be an unquoted column name although
this argument is passed by expression and supports
\link[rlang:nse-force]{quasiquotation} (you can unquote column
names). For \verb{_vec()} functions, a \code{numeric} vector.}

\item{estimate}{The column identifier for the predicted
results (that is also \code{numeric}). As with \code{truth} this can be
specified different ways but the primary method is to use an
unquoted variable name. For \verb{_vec()} functions, a \code{numeric} vector.}

\item{delta}{A single \code{numeric} value. Defines the boundary where the loss function
transitions from quadratic to linear. Defaults to 1.}

\item{na_rm}{A \code{logical} value indicating whether \code{NA}
values should be stripped before the computation proceeds.}
}
\value{
A \code{tibble} with columns \code{.metric}, \code{.estimator},
and \code{.estimate} and 1 row of values.

For grouped data frames, the number of rows returned will be the same as
the number of groups.

For \code{huber_loss_vec()}, a single \code{numeric} value (or \code{NA}).
}
\description{
Calculate the Huber loss, a loss function used in robust regression. This
loss function is less sensitive to outliers than \code{\link[=rmse]{rmse()}}. This function is
quadratic for small residual values and linear for large residual values.
}
\examples{
# Supply truth and predictions as bare column names
huber_loss(solubility_test, solubility, prediction)

library(dplyr)

set.seed(1234)
size <- 100
times <- 10

# create 10 resamples
solubility_resampled <- bind_rows(
  replicate(
    n = times,
    expr = sample_n(solubility_test, size, replace = TRUE),
    simplify = FALSE
  ),
  .id = "resample"
)

# Compute the metric by group
metric_results <- solubility_resampled \%>\%
  group_by(resample) \%>\%
  huber_loss(solubility, prediction)

metric_results

# Resampled mean estimate
metric_results \%>\%
  summarise(avg_estimate = mean(.estimate))
}
\references{
Huber, P. (1964). Robust Estimation of a Location Parameter.
\emph{Annals of Statistics}, 53 (1), 73-101.
}
\seealso{
Other numeric metrics: 
\code{\link{ccc}()},
\code{\link{huber_loss_pseudo}()},
\code{\link{iic}()},
\code{\link{mae}()},
\code{\link{mape}()},
\code{\link{mase}()},
\code{\link{mpe}()},
\code{\link{msd}()},
\code{\link{poisson_log_loss}()},
\code{\link{rmse}()},
\code{\link{rpd}()},
\code{\link{rpiq}()},
\code{\link{rsq_trad}()},
\code{\link{rsq}()},
\code{\link{smape}()}

Other accuracy metrics: 
\code{\link{ccc}()},
\code{\link{huber_loss_pseudo}()},
\code{\link{iic}()},
\code{\link{mae}()},
\code{\link{mape}()},
\code{\link{mase}()},
\code{\link{mpe}()},
\code{\link{msd}()},
\code{\link{poisson_log_loss}()},
\code{\link{rmse}()},
\code{\link{smape}()}
}
\author{
James Blair
}
\concept{accuracy metrics}
\concept{numeric metrics}
