% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yml_helpers.R
\name{yml_blank}
\alias{yml_blank}
\alias{is_yml_blank}
\title{Return a blank object to be discarded from YAML}
\usage{
yml_blank()

is_yml_blank(x)
}
\arguments{
\item{x}{a field from a \code{yml} object}
}
\value{
a \code{yml_blank} object
}
\description{
ymlthis treats \code{NULL}, \code{NA}, and other common argument defaults as literal
(e.g. \code{author = NULL} will produce "author: null"). \code{yml_blank()} is a helper
function to indicate that the field should not be included. \code{yml_blank()} is
primarily used as a default argument for fields that should not be included
by default.
}
\examples{

yml() \%>\%
  yml_replace(author = yml_blank()) \%>\%
  yml_discard(~is_yml_blank(.x))


}
\seealso{
\code{\link[=yml_discard]{yml_discard()}}, \code{\link[=yml_replace]{yml_replace()}}
}
