% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teamBattingScorecardAllOppnAllMatches.R
\name{teamBattingScorecardAllOppnAllMatches}
\alias{teamBattingScorecardAllOppnAllMatches}
\title{Team batting scorecard against all oppositions in all matches}
\usage{
teamBattingScorecardAllOppnAllMatches(matches,theTeam)
}
\arguments{
\item{matches}{All matches of the team in all matches with all oppositions}

\item{theTeam}{The team for which the the batting partnerships are sought}
}
\value{
details
The data frame of the scorecard of the team in all matches against all oppositions
}
\description{
This function omputes and returns the batting scorecard of a team in all matches against all
oppositions. The data frame has the ball played, 4's,6's and runs scored by batsman
}
\note{
Maintainer: Tinniam V Ganesh \email{tvganesh.85@gmail.com}
}
\examples{
\dontrun{
# Get all matches between India with all oppositions
matches <-getAllMatchesAllOpposition("India",dir="../data/",save=TRUE)

# This can also be loaded from saved file
# load("allMatchesAllOpposition-India.RData")

# Top batsman is displayed in descending order of runs
teamBattingScorecardAllOppnAllMatches(matches,theTeam="India")

# The best England players scorecard against India is shown
teamBattingScorecardAllOppnAllMatches(matches,theTeam="England")
}

}
\author{
Tinniam V Ganesh
}
\references{
\url{http://cricsheet.org/}\cr
\url{https://gigadom.wordpress.com/}\cr
\url{https://github.com/tvganesh/yorkrData}
}
\seealso{
\code{\link{teamBatsmenVsBowlersAllOppnAllMatchesPlot}}\cr
\code{\link{teamBatsmenPartnershipOppnAllMatchesChart}}\cr
\code{\link{teamBatsmenPartnershipAllOppnAllMatchesPlot}}\cr
\code{\link{teamBowlingWicketRunsAllOppnAllMatches}}
}

