% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json.R
\name{read_json_file}
\alias{read_json_file}
\title{Convert JSON to R}
\usage{
read_json_file(filename, opts = list(), ...)
}
\arguments{
\item{filename}{full path to text file containing JSON.}

\item{opts}{Named list of options for parsing. Usually created by \code{opts_read_json()}}

\item{...}{Other named options can be used to override any options in \code{opts}.
The valid named options are identical to arguments to \code{\link[=opts_read_json]{opts_read_json()}}}
}
\value{
R object
}
\description{
Convert JSON to R
}
\examples{
tmp <- tempfile()
write_json_file(head(iris, 3), tmp)
read_json_file(tmp)
}
\seealso{
Other JSON Parsers: 
\code{\link{read_json_conn}()},
\code{\link{read_json_raw}()},
\code{\link{read_json_str}()},
\code{\link{read_ndjson_file}()},
\code{\link{read_ndjson_str}()}
}
\concept{JSON Parsers}
