% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geojson.R
\name{write_geojson_str}
\alias{write_geojson_str}
\alias{write_geojson_file}
\title{Write SF to GeoJSON string}
\usage{
write_geojson_str(x, opts = list(), ..., json_opts = list())

write_geojson_file(x, filename, opts = list(), ..., json_opts = list())
}
\arguments{
\item{x}{\code{sf} object. Supports \code{sf} or \code{sfc}}

\item{opts}{named list of options. Usually created with \code{opts_write_geojson()}.
Default: empty \code{list()} to use the default options.}

\item{...}{any extra named options override those in \code{opts}}

\item{json_opts}{Named list of vanilla JSON options as used by \code{write_json_str()}.
This is usually created with \code{opts_write_json()}.  Default value is
an empty \code{list()} which means to use all the default JSON writing
options which is usually the correct thing to do when writing GeoJSON.}

\item{filename}{filename}
}
\value{
Character string containing GeoJSON, or \code{NULL} if GeoJSON
written to file.
}
\description{
Write SF to GeoJSON string
}
\examples{
geojson_file <- system.file("geojson-example.json", package = 'yyjsonr')
sf <- read_geojson_file(geojson_file)
cat(write_geojson_str(sf, json_opts = opts_write_json(pretty = TRUE)))
}
