% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subgroups.R
\name{subgroups}
\alias{subgroups}
\title{Local Association Subgroup Analysis}
\usage{
subgroups(las, x, select, continuous, breaks, default_breaks = 4,
  thresholds = c(-0.05, 0.05), significance, alpha = 0.01)
}
\arguments{
\item{las}{\code{\link[zebu]{lassie}} S3 object. Corresponds to associated variables.}

\item{x}{data.frame or matrix. Corresponds to interacting variable(s) specified by \code{select}.}

\item{select}{optional vector of column numbers or column names specifying a subset of data to be used.
By default, uses all colnames in \code{x} except those in \code{las} object.}

\item{continuous}{optional vector of column numbers or column names specifying
continuous variables that should be discretized.
By default, assumes that every variable is categorical.}

\item{breaks}{numeric vector or list passed on to \code{\link[base]{cut}} to discretize
continuous variables. When a numeric vector is specified, break points are
applied to all continuous variables. In order to specify variable-specific
breaks, lists are used. List names identify variables and list values identify
breaks. List names are column names (not numbers). If a continuous
variable has no specified breaks, then \code{default_breaks} will be applied.}

\item{default_breaks}{default break points for discretizations.
Same syntax as in \code{\link[base]{cut}}.}

\item{thresholds}{vector specifying respectively the negative and the positive
association threshold. Local association values between these thresholds are considered independent.
Values not contained in this range are classified as independent.}

\item{significance}{optional logical value specifying if only non-significant local association
values should be considered as independent.
Only available if \code{las} is also a \code{\link[zebu]{permtest}} object.}

\item{alpha}{alpha error level. Local association with p-values above this value are considered
as independent. Only available if \code{las} is also a \code{\link[zebu]{permtest}} object.}
}
\value{
An instance of S3 \link[base]{class} \code{\link[zebu]{lassie}}.
}
\description{
Identifies if the local association between variables (named associated variables)
is dependent on the value of an another variable (named interacting variable).
Associated variables are specified by \code{las}. Interacting variable(s)
values are specified by \code{x}.
}
\details{
Associated variables events are recoded into a subgroup variable according to local
association values (and eventually significance) into 'positive', 'negative' and 'independent'.
This is specified by the \code{thresholds}, \code{significance} and \code{alpha} arguments.
The local (and global) association between the new subgroup variable
and the interacting variable is then estimated using \code{\link[zebu]{lassie}}.
}
\examples{
# In this example, we will use the zebu 'trial' dataset.
# See vignette example for more detailed explanation

# 'trial' corresponds to a simulated clinical trial where patient recovery
# is dependent on drug intake ('drug') and resistance status ('resistance').
# Patient recovery is monitored by a biomarker (continuous variable from 0 to 1)
# Patients with post-treatment biomarker ('postbiom') above 0.7 is have recovered.

# Load 'trial' dataset
data(trial)

# Compute the association between drug intake and patient recovery
las <- lassie(trial,
              select = c("drug", "postbiom"),
              continuous = c("postbiom"),
              breaks = c(0, 0.7, 1))

# Permuation test
# Access significance of global and local association
las <- permtest(las)

# Global association between drug intake and recovery but not for all patients
# Being in the drug group is locally independent of having not recovered
print(las)

# Local association subgroup analysis
sub <- subgroups(las, trial, select = "resistance", alpha = 0.01)

# Variable 'resistance' explains differences between sensitive and resistance patients
print(sub)

}
\seealso{
Significance can be accessed using a permutation test: \code{\link[zebu]{permtest}}.
}
