% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/functions_package.R
\name{Zeta.decline}
\alias{Zeta.decline}
\title{Zeta diversity decline}
\usage{
Zeta.decline(data.spec, orders = 1:10, sam = 1000, plot = TRUE,
  sd = TRUE)
}
\arguments{
\item{data.spec}{Site-by-species presence-absence data frame, with sites as rows and species as columns.}

\item{orders}{Range of number of assemblages or sites for which zeta diversity is computed.}

\item{sam}{Number of samples for which the zeta-diversity is computed for each number of assemblages or sites.}

\item{plot}{Boolean value (TRUE or FALSE) indicating if the outputs must be plotted.}

\item{sd}{Boolean value (TRUE or FALSE) indicating if the standard deviation of each zeta-diversity value must be plotted.}
}
\value{
\code{Zeta.decline} returns a list containing the following components:

\item{zeta.order}{The number of assemblages or sites for which the zeta-diversity was computed.}

\item{zeta.val}{The zeta-diversity values.}

\item{zeta.val.sd}{The zeta-diversity standard deviation values.}

\item{zeta.exp}{Object of class "\code{lm}", containing the output of the exponential regression.}

\item{zeta.pl}{Object of class "\code{lm}", containing the output of the power law regression.}

\item{aic}{AIC values for \code{zeta.exp} and \code{zeta.pl}.}
}
\description{
Computes zeta diversity, the number of species shared by multiple assemblages, for a range of orders (number of assemblages or sites), from 1 to 'order'.
}
\examples{
data(BCI.spec.coarse)
xy <- BCI.spec.coarse[1:2]
data.spec <- BCI.spec.coarse[3:308]

dev.new(width = 12, height = 4)
zeta <- Zeta.decline(data.spec, orders = 1:5, sam = 100)
zeta

##########

data(Marion.species)
xy <- Marion.species[1:2]
data.species <- Marion.species[3:33]

dev.new(width = 12, height = 4)
zeta.species <- Zeta.decline(data.species, orders = 1:5, sam = 100)
zeta.species
}
\references{
Hui C. & McGeoch M.A. (2014). Zeta diversity as a concept and metric that unifies incidence-based biodiversity patterns. \emph{The American Naturalist}, 184, 684-694.
}
\seealso{
\code{\link{Zeta.order}}
}

