% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zipfpeMoments.R
\name{zipfpeMoments}
\alias{zipfpeMoments}
\title{Distribution Moments.}
\usage{
zipfpeMoments(k, alpha, beta, tolerance = 10^(-4))
}
\arguments{
\item{k}{Order of the moment to compute.}

\item{alpha}{Value of the \eqn{\alpha} parameter (\eqn{\alpha > k + 1}).}

\item{beta}{Value of the \eqn{\beta} parameter (\eqn{\beta \in (-\infty, +\infty)}).}

\item{tolerance}{Tolerance used in the calculations (default = \eqn{10^{-4}}).}
}
\value{
A positive real value corresponding to the k-th moment of the distribution.
}
\description{
General function to compute the k-th moment of the Zipf-PE distribution for any integer value \eqn{k \geq 1},
when it exists. The k-th moment exists if and only if  \eqn{\alpha > k + 1}.
For k = 1, this function returns the same value as the \link{zipfpeMean} function.
}
\details{
The k-th moment of the Zipf-PE distribution is finite for \eqn{\alpha} values strictly greater than \eqn{k + 1}.
It is computed by calculating the partial sums of the serie, and stopping when two
consecutive partial sums differ less than the \code{tolerance} value.
The value of the last partial sum is returned.
}
\examples{
zipfpeMoments(3, 4.5, 1.3)
zipfpeMoments(3, 4.5, 1.3,  1*10^(-3))
}
