% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R,
%   R/ZGroupCurvesDataFrame-methods.R, R/zresults-methods.R,
%   R/zvariant-methods.R
\docType{methods}
\name{groupnames}
\alias{groupnames}
\alias{groupnames<-}
\alias{groupnames,ZGroupCurvesDataFrame-method}
\alias{groupnames,Zresults-method}
\alias{groupnames,Zvariant-method}
\alias{groupnames<-}
\alias{groupnames<-,Zvariant,character-method}
\title{Get group names for a class \code{Zvariant} instance.}
\usage{
groupnames(x)

groupnames(x) <- value

\S4method{groupnames}{ZGroupCurvesDataFrame}(x)

\S4method{groupnames}{Zresults}(x)

\S4method{groupnames}{Zvariant}(x)

\S4method{groupnames}{Zvariant,character}(x) <- value
}
\arguments{
\item{x}{Zvariant object.}

\item{value}{named character vector.}
}
\value{
A character vector containing the group names. If there are no
        groups, return NA.
}
\description{
Get group names for a class \code{Zvariant} instance.

Group names can be assigned to a \code{\link{Zvariant}} or
\code{\link{Zresults}} object. This is a replacement function for variant
group names. If the particular variant doesn't use groups the gives a
warning.
}
\details{
All current group codes must be found in the keys, i.e. there can't be
missing values. Argument \code{value} can, however, contain keys that are
not in the current group codes.
}
\seealso{
\code{\link{Zvariant-class}} \code{\link{groupnames}}
         \code{\link{groups}}

\code{\link{Zvariant-class}} \code{\link{groupnames}}
         \code{\link{Zresults}} \code{\link{groups}}
}
\author{
Joona Lehtomaki \email{joona.lehtomaki@gmail.com}
}
