% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChangeWorkflow.R
\name{ChangeWorkflow}
\alias{ChangeWorkflow}
\title{Change a workflow and rerun.}
\usage{
ChangeWorkflow(
  workflow,
  occurrence = NULL,
  covariate = NULL,
  process = NULL,
  model = NULL,
  output = NULL,
  forceReproducible = NULL
)
}
\arguments{
\item{workflow}{A zoonWorkflow object from a previous zoon analysis}

\item{occurrence, covariate, process, model, output}{Optional modules (or lists or Chains) to
replace the modules in \code{workflow}}

\item{forceReproducible}{Optional logical. Whether to force zoon to collect modules
from the online repo in the new workflow. This ensure the analysis is reproducible.}
}
\value{
A list with the results of each module and a copy of the
 call used to execute the workflow (
}
\description{
Takes a workflow object and reruns it with changes.
}
\examples{
\dontrun{
w <- workflow(UKAnophelesPlumbeus,
              UKAir,
              Background(n = 70),
              LogisticRegression,
              PrintMap)

w2 <- ChangeWorkflow(w,
                     output = PrintMap)
}
}
