% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zstd.R
\name{zstdDecompress}
\alias{zstdDecompress}
\title{Zstandard comression}
\usage{
zstdDecompress(data)
}
\arguments{
\item{data}{input data to be decomressed}
}
\value{
decompressed data
}
\description{
Zstandard, or zstd as short version, is a fast lossless compression algorithm, targeting real-time compression scenarios
at zlib-level and better compression ratios.
}
\details{
Decompresses data previously compressed with \link{zstdCompress}
}
\examples{
# Simple example
library(zstdr)
data_file <- file.path(R.home(), "COPYING")
data <- readBin(data_file, raw(), file.info(data_file)$size)
compressed <- zstdCompress(data)
stopifnot(identical(data, zstdDecompress(compressed)))
}
\seealso{
\link{memCompress} \link{zstdCompress} \link{zstdMaxCLevel}
}
