% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image2palettes.r
\name{image2palettes}
\alias{image2palettes}
\title{image2palettes}
\usage{
image2palettes(
  array,
  resize = 4,
  unique = FALSE,
  scale = F,
  k = 3,
  lcols = 7,
  plsaxis = 1,
  cex = 5,
  cext = 0.5
)
}
\arguments{
\item{array}{array: rgb array}

\item{resize}{numeric: desidered resize factor}

\item{unique}{logical: if TRUE each color is counted once}

\item{scale}{logical: if TRUE (color) variables are scaled}

\item{k}{numeric: desidered number of clusters (i.e., number of palettes)}

\item{lcols}{numeric: length of the color vector of each palette}

\item{plsaxis}{numeric: desidered PLS axis}

\item{cex}{numeric: size of colored squares}

\item{cext}{numeric: size of color names}
}
\value{
paletteslist list: color palettes arranged in a list
}
\description{
Create palettes from an image
}
\examples{
\dontrun{
require(jpeg)
require(Morpho)
data("Altapic")
image2palettes(Altapic,resize=1,unique=T,scale=T,k=3,lcols=5,plsaxis=1,cext=0.5)
}
}
\author{
Antonio Profico
}
