% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AsyK.R
\name{mse}
\alias{mse}
\title{Calculate Mean Squared Error( MSE) by using different Kernels}
\usage{
mse(kernel, type)
}
\arguments{
\item{kernel}{type of kernel which is to be used}

\item{type}{mention distribution of vector.If exponential distribution then use \code{"Exp"}.
If use gamma distribution then use \code{"Gamma"}.If Weibull distribution then use \code{"Weibull"}.}
}
\value{
Mean Squared Error (MSE)
}
\description{
This function calculates the mean squared error (MSE) by using user specified kernel.This function is same as provided in package "DELTD". For details see \url{https://CRAN.R-project.org/package=DELTD}.
}
\examples{
y <- rexp(100, 1)
xx <- seq(min(y) + 0.05, max(y), length = 500)
h <- 2
gr <- Laplace(x = xx, y = y, k = 200, h = h)
mse(kernel = gr, type = "Exp")
## if distribution is other than mentioned \code{type} is used then NaN will be produced.
\dontrun{
mse(kernel = gr, type ="Beta")
}
}
\references{
\url{https://CRAN.R-project.org/package=DELTD}
}
\seealso{
This is also available in \pkg{DELTD}
}
\author{
Javaria Ahmad Khan, Atif Akbar.
}
