% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_ef.R
\name{calculate_ef}
\alias{calculate_ef}
\title{Calculate Efficiency Factor (EF) Data}
\usage{
calculate_ef(
  stoken,
  activity_type = c("Run", "Ride"),
  ef_metric = c("Pace_HR", "Power_HR"),
  start_date = NULL,
  end_date = NULL,
  min_duration_mins = 20
)
}
\arguments{
\item{stoken}{A valid Strava token object obtained using \code{rStrava::strava_oauth()}.}

\item{activity_type}{Character vector or single string specifying activity type(s).}

\item{ef_metric}{Character string specifying the EF metric ("Pace_HR" or "Power_HR").}

\item{start_date}{Optional start date (YYYY-MM-DD string or Date object). Defaults to one year ago.}

\item{end_date}{Optional end date (YYYY-MM-DD string or Date object). Defaults to today.}

\item{min_duration_mins}{Numeric, minimum activity duration in minutes. Default 20.}
}
\value{
A data frame with columns: date, activity_type, ef_value.
}
\description{
Calculates Efficiency Factor (Pace/HR or Power/HR) from Strava activities.
}
\details{
Fetches activity summaries and calculates EF (output/HR) for each.
Provides the data used by `plot_ef`.
}
\examples{
# Example using simulated data
data(Athlytics_sample_data)
print(head(athlytics_sample_ef))

\dontrun{
# Example using real data (requires authentication)
# To authenticate (replace with your details):
# stoken <- rStrava::strava_oauth(app_name = "YOUR_APP",
#                                client_id = "YOUR_ID",
#                                client_secret = "YOUR_SECRET",
#                                cache = TRUE)

# Calculate Pace/HR efficiency factor for Runs
# Ensure stoken is defined and valid before running this part
# ef_data_run <- calculate_ef(stoken = stoken, activity_type = "Run", ef_metric = "Pace_HR")
# print(tail(ef_data_run))

# Calculate Power/HR efficiency factor for Rides
# Ensure stoken is defined and valid before running this part
# ef_data_ride <- calculate_ef(stoken = stoken, activity_type = "Ride", ef_metric = "Power_HR")
# print(tail(ef_data_ride))
}
}
