% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strava_helpers.R
\name{fetch_strava_activities}
\alias{fetch_strava_activities}
\title{(Internal) Fetch and Compile Strava Activities}
\usage{
fetch_strava_activities(
  stoken,
  start_date = NULL,
  end_date = NULL,
  fetch_details = FALSE,
  required_cols = c("average_watts", "average_heartrate"),
  delay = 1
)
}
\arguments{
\item{stoken}{A valid Strava token from `rStrava::strava_oauth()`.}

\item{start_date}{Optional. Start date (YYYY-MM-DD or Date/POSIXct) for fetching. Defaults to ~2009.}

\item{end_date}{Optional. End date (YYYY-MM-DD or Date/POSIXct) for fetching. Defaults to now.}

\item{fetch_details}{Fetch detailed data for each activity using `get_activity()`?
Needed for power/HR metrics but much slower and uses more API calls. Default `FALSE`.}

\item{required_cols}{If `fetch_details = TRUE`, which detailed columns to attempt
to extract (e.g., `c("average_watts", "average_heartrate")`).}

\item{delay}{Seconds to pause between `get_activity` calls when `fetch_details = TRUE`
to manage API rate limits. Default 1.}
}
\value{
A tibble of activity data. Columns vary based on `fetch_details`.
  Includes a `date` column derived from `start_date_local`.
}
\description{
Helper function to get Strava activity data within a date range.
}
\details{
Retrieves a summary list of activities and optionally fetches detailed
data for each activity if needed for specific metrics (e.g., power).
Intended for internal use within the package.

This function wraps `rStrava::get_activity_list` and
  `rStrava::compile_activities`. If `fetch_details` is enabled, it iteratively
  calls `rStrava::get_activity` for each activity, which is the main performance
  bottleneck and API usage driver.
}
\keyword{internal}
