% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/authentication.R
\name{getToken}
\alias{getToken}
\title{Get a 2-Legged Token for Authentication.}
\usage{
getToken(id = NULL, secret = NULL, scope = "data:write data:read")
}
\arguments{
\item{id}{A string. Client ID for the app generated from the AutoDesk Dev
Portal.}

\item{secret}{A string. Client Secret for the app generated from the AutoDesk
Dev Portal.}

\item{scope}{A string. Space-separated list of required scopes. May be
\code{user-profile:read}, \code{data:read}, \code{data:write},
\code{data:create}, \code{data:search}, \code{bucket:create},
\code{bucket:read}, \code{bucket:update}, \code{bucket:delete},
\code{code:all}, \code{account:read}, \code{account:write}, or a
combination of these.}
}
\value{
An object containing the \code{access_token}, \code{code_type}, and
  \code{expires_in} milliseconds.
}
\description{
Get a 2-legged token for OAuth-based authentication to the AutoDesk Forge
Platform.
}
\examples{
\dontrun{
# Get a 2-legged token with the "data:read" and "data:write" scopes
resp <- getToken(id = Sys.getenv("client_id"), secret = Sys.getenv("client_secret"),
           scope = "data:write data:read")
myToken <- resp$content$access_token
}
}
