% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataManagement.R
\name{uploadFile}
\alias{uploadFile}
\title{Upload a File to an App-Managed Bucket.}
\usage{
uploadFile(file = NULL, token = NULL, bucket = "mybucket")
}
\arguments{
\item{file}{A string. File path.}

\item{token}{A string. Token generated with \code{\link{getToken}} function
with \code{bucket:create}, \code{bucket:read}, and \code{data:write}
scopes.}

\item{bucket}{A string. Unique bucket name. Defaults to \code{mybucket}.}
}
\value{
An object containing the \code{bucketKey}, \code{objectId} (i.e.
  urn), \code{objectKey} (i.e. file name), \code{size}, \code{contentType}
  (i.e. "application/octet-stream"), \code{location}. and other content
  information.
}
\description{
Upload a design file to an app-managed bucket using the Data Management API.
}
\examples{
\dontrun{
# Upload the "aerial.dwg" file to "mybucket"
resp <- uploadFile(file = system.file("inst/samples/aerial.dwg", package = "AutoDeskR"),
           token = myToken, bucket = "mybucket")
myUrn <- resp$content$objectId
}
}
