% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MLEpoisBCD.R
\name{MLEpoisBCD}
\alias{MLEpoisBCD}
\title{Maximum Likelihood Estimation for a Bivariate Poisson Distribution via Conditional Specification}
\usage{
MLEpoisBCD(data, initial_values = NULL)
}
\arguments{
\item{data}{data frame or matrix with two columns, representing paired observations of count variables \eqn{(X, Y)}.}

\item{initial_values}{optional named list with initial values for the parameters: \code{lambda1}, \code{lambda2}, and \code{lambda3}.
If not provided, the function computes heuristic starting values.}
}
\value{
A list of class \code{"MLEpoisBCD"} containing:
\describe{
  \item{\code{lambda1}}{estimated lambda1.}
  \item{\code{lambda2}}{estimated lambda2.}
  \item{\code{lambda3}}{estimated dependence parameter (must be in (0, 1]).}
  \item{\code{logLik}}{Maximum log-likelihood achieved.}
  \item{\code{AIC}}{Akaike Information Criterion.}
  \item{\code{BIC}}{Bayesian Information Criterion.}
  \item{\code{convergence}}{Convergence status from the optimizer (0 means successful).}
}
}
\description{
Estimates the parameters of a bivariate Poisson distribution via Conditional Specification using maximum likelihood.
}
\details{
The model estimates parameters from a joint distribution for \eqn{(X, Y)} with the form:
\deqn{
P(X = x, Y = y) = K(\lambda_1, \lambda_2, \lambda_3) \frac{\lambda_1^x \lambda_2^y \lambda_3^{xy}}{x! y!},
}
where \eqn{ x, y = 0, 1, 2, \ldots }, and \eqn{ K(\lambda_1, \lambda_2, \lambda_3) } is the normalizing constant.
}
\examples{
# Simulate data
data <- rpoisBCD(n = 50, lambda1 = 3, lambda2 = 5, lambda3 = 1)
result <- MLEpoisBCD(data)
print(result)

data(eplSeasonGoals)
MLEpoisBCD(eplSeasonGoals[["1819"]])

data(lensfaults)
MLEpoisBCD(lensfaults)
}
\seealso{
\code{\link{dpoisBCD}} \code{\link{ppoisBCD}} \code{\link{rpoisBCD}}
}
