% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpoisBCD.R
\name{dpoisBCD}
\alias{dpoisBCD}
\title{Joint Probability Mass Function for a Bivariate Poisson Distribution via Conditional Specification}
\usage{
dpoisBCD(x, y, lambda1, lambda2, lambda3)
}
\arguments{
\item{x}{value of \eqn{ X } that must be a non-negative integer}

\item{y}{value of \eqn{ Y } that must be a non-negative integer}

\item{lambda1}{rate parameter for \eqn{ X } that must be positive}

\item{lambda2}{rate parameter for \eqn{ Y } that must be positive}

\item{lambda3}{dependence parameter that must be \eqn{(0, 1]}}
}
\value{
probability \eqn{ P(X = x, Y = y) } for each pair of \eqn{ x } and \eqn{ y }.
}
\description{
Computes the joint probability mass function (p.m.f.) of a Bivariate Poisson Conditionals distribution (BPCD) based on Ghosh, Marques, and Chakraborty (2021).
}
\details{
The joint p.m.f. of the BGCD is
\deqn{
P(X = x, Y = y) = K(\lambda_1, \lambda_2, \lambda_3) \frac{\lambda_1^x \lambda_2^y \lambda_3^{xy}}{x! y!},
}
where \eqn{ x, y = 0, 1, 2, \ldots }, and \eqn{ K(\lambda_1, \lambda_2, \lambda_3) } is the normalizing constant computed by the function \code{normalize_constant_BPCD}.

Key properties of the BPCD include:

- Negative correlation for \eqn{ \lambda_3 < 1 },

- Independence for \eqn{ \lambda_3 = 1 }.
}
\examples{
# Compute P(X = 1, Y = 2) with lambda1 = 0.5, lambda2 = 0.5, lambda3 = 0.5
dpoisBCD(x = 1, y = 2, lambda1 = 0.5, lambda2 =  0.5, lambda3 =  0.5)

# Compute P(X = 0, Y = 1) with lambda1 = 0.5, lambda2 = 0.5, lambda3 = 0.5
dpoisBCD(x = 0, y = 1, lambda1 = 0.5, lambda2 =  0.5, lambda3 =  0.5)

}
\references{
Ghosh, I., Marques, F., & Chakraborty, S. (2021). A new bivariate Poisson distribution via conditional specification: properties and applications. \emph{Journal of Applied Statistics}, 48(16), 3025-3047. \doi{10.1080/02664763.2020.1793307}
}
\seealso{
\code{\link{rpoisBCD}}, \code{\link{ppoisBCD}}
}
