% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchBeid.R
\name{searchBeid}
\alias{searchBeid}
\title{Search a BEID}
\usage{
searchBeid(x, maxHits = 75, clean_id_search = TRUE, clean_name_search = TRUE)
}
\arguments{
\item{x}{a character value to search}

\item{maxHits}{maximum number of raw hits to return}

\item{clean_id_search}{clean x to avoid error during ID search.
Default: TRUE. Set it to false if you're sure of your lucene query.}

\item{clean_name_search}{clean x to avoid error during ID search.
Default: TRUE. Set it to false if you're sure of your lucene query.}
}
\value{
NULL if there is not any match or
a data.frame with the following columns:
\itemize{
\item \strong{value}: the matching term
\item \strong{from}: the type of the matched term (e.g. BESymbol, GeneID...)
\item \strong{be}: the matching biological entity (BE)
\item \strong{beid}: the BE identifier
\item \strong{source}: the BEID reference database
\item \strong{preferred}: TRUE if the BEID is considered as a preferred identifier
\item \strong{symbol}: BEID canonical symbol
\item \strong{name}: BEID name
\item \strong{entity}: technical BE identifier
\item \strong{GeneID}: Corresponding gene identifier
\item \strong{Gene_source}: Gene ID database
\item \strong{preferred_gene}: TRUE if the GeneID is considered as a preferred identifier
\item \strong{Gene_symbol}: Gene symbol
\item \strong{Gene_name}: Gene name
\item \strong{Gene_entity}: technical gene identifier
\item \strong{organism}: gene organism (scientific name)
\item \strong{score}: score of the fuzzy search
\item \strong{included}: is the search term fully included in the value
\item \strong{exact}: is the value an exact match of the term
}
}
\description{
Search a BEID
}
