% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BLRPM.R
\name{BLRPM.OF}
\alias{BLRPM.OF}
\title{BLRPM objective function for parameter estimation}
\usage{
BLRPM.OF(par, stats, acc.vals = c(1, 3, 12, 24), weights = rep(1,
  length(stats)), debug = FALSE, scale = 1, use.log = TRUE, OF = 2)
}
\arguments{
\item{par}{\code{vector} specifying the five model parameters (lambda,gamma,beta,eta,mux) at which the objective function is to be calculated}

\item{stats}{\code{vector} specifying the time series statistics to which the model is compared to}

\item{acc.vals}{\code{vector} specifying the accumulation time steps at which the model statistics are calculated}

\item{weights}{\code{vector} specifying the weight of each statistic in the objective function. 
Note: has to have the same length as \code{stats}}

\item{debug}{\code{logical} defining if debuggging of function has to be done}

\item{scale}{\code{value} spacifying the scale factor for comparisson between duration parameters gamma and eta}

\item{use.log}{\code{logical} defining if input parameters are logarithmic}

\item{OF}{\code{value} specifying the type of objective function. 1: quadratic, 2: quad extended, 3: absolute, 4: abs extended}
}
\value{
Z returns value of objective function for input parameters and input statistics
}
\description{
\code{BLRPM.OF} is the objective function used for parameter estimation of the BLRPM parameters. 
Given a set of BLRPM parameters \code{par} this function calculates a set of model statistics at
given accumulation time steps \code{acc.vals}. These model statistics are compared with given
time series statistics \code{stats} in the objective function. The user is able to define \code{weights}
for each statistic (has to be the same length as statistics input vector). Option for debugging is given.
A \code{scale} parameter defines a criterium for which different kinds of model statistics are calculated.
This criterium is mainly based on the timescale difference between storm duration parameter gamma and cell duration
parameter eta.
If \code{use.log} is true, the objective function needs logarithmic input parameters. The value
of \code{OF} defines the kind of objective function to be used: 1= quadratic 2= quadratic extended 3= absolute 4= absolute extended.
}
\author{
Christoph Ritschel \email{christoph.ritschel@met.fu-berlin.de}
}

