% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prob_zk.R
\name{prob_zk}
\alias{prob_zk}
\title{Posterior Density Estimation at a Single Location}
\usage{
prob_zk(x, data_object, model, nugget, sill, range,
               nsmax = 5, nhmax = 5, n = 50,
               zk_range = extended_range(data_object))
}
\arguments{
\item{x}{A two-column matrix of spatial coordinates for a single estimation
location.}

\item{data_object}{A list containing the hard and soft data.}

\item{model}{A string specifying the variogram or covariance model to use
(e.g., \code{"exp"}, \code{"sph"}, etc.).}

\item{nugget}{A non-negative numeric value for the nugget effect in the
variogram model.}

\item{sill}{A numeric value representing the sill (total variance) in the
variogram model.}

\item{range}{A positive numeric value for the range (or effective range)
parameter of the variogram model.}

\item{nsmax}{An integer specifying the maximum number of nearby soft data
points to include for estimation (default is 5).}

\item{nhmax}{An integer specifying the maximum number of nearby hard data
points to include for estimation (default is 5).}

\item{n}{An integer indicating the number of points at which to evaluate the
posterior density over \code{zk_range} (default is 50).}

\item{zk_range}{A numeric vector specifying the range over which to evaluate
the unobserved value at the estimation location (\code{zk}). Although
\code{zk} is unknown,  it is assumed to lie within a range similar to
the observed data (\code{zh}, \code{a}, and \code{b}). It is advisable
to explore the posterior distribution at a few locations using
\code{prob_zk()} before finalizing this range}
}
\value{
A data frame with two columns: \code{zk_i} (assumed zk values) and
\code{prob_zk_i} (corresponding posterior densities).
}
\description{
Computes the posterior and plots probability density function (PDF) at a
single unobserved spatial location using the Bayesian Maximum Entropy (BME)
framework. This function integrates both hard data (precise measurements) and
soft data (interval or uncertain observations), together with a specified
variogram model, to numerically estimate the posterior density across a
range of possible values.
}
\examples{
data("utsnowload")
x <- utsnowload[1, c("latitude", "longitude")]
ch <- utsnowload[2:67, c("latitude", "longitude")]
cs <- utsnowload[68:232, c("latitude", "longitude")]
zh <- utsnowload[2:67, "hard"]
a <- utsnowload[68:232, "lower"]
b <- utsnowload[68:232, "upper"]
data_object <- bme_map(ch, cs, zh, a , b)
prob_zk(x, data_object, model = "exp",
        nugget = 0.0953, sill = 0.3639, range = 1.0787)

}
