% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BMTchangepars.R
\name{BMTchangepars}
\alias{BMTchangepars}
\title{The BMT Distribution Parameter Conversion.}
\usage{
BMTchangepars(
  p3,
  p4,
  type.p.3.4 = "t w",
  p1 = NULL,
  p2 = NULL,
  type.p.1.2 = NULL
)
}
\arguments{
\item{p3, p4}{tails weights (\eqn{\kappa_l} and \eqn{\kappa_r}) or 
asymmetry-steepness (\eqn{\zeta} and \eqn{\xi}) parameters of the BMT 
distribution.}

\item{type.p.3.4}{type of parametrization associated to p3 and p4. "t w" means
tails weights parametrization (default) and "a-s" means asymmetry-steepness
parametrization.}

\item{p1, p2}{domain (minimum and maximum) or location-scale (mean and 
standard deviation) parameters of the BMT distribution.}

\item{type.p.1.2}{type of parametrization associated to p1 and p2. "c-d" means
domain parametrization (default) and "l-s" means location-scale 
parametrization.}
}
\value{
\code{BMTchangepars} reparametrize \code{p3}, \code{p4}, \code{p1}, 
  \code{p2} according to the alternative parameterizations from the given 
  \code{type.p.3.4} and \code{type.p.1.2}. \code{BMTchangepars} returns a 
  list with the alternative arguments to those received.
  
  The arguments are recycled to the length of the result. Only the first 
  elements of \code{type.p.3.4} and \code{type.p.1.2} are used.
  
  If \code{type.p.3.4 == "t w"}, \code{p3 < 0} and \code{p3 > 1} are errors 
  and return \code{NaN}.
  
  If \code{type.p.3.4 == "a-s"}, \code{p3 < -1} and \code{p3 > 1} are errors 
  and return \code{NaN}.
  
  \code{p4 < 0} and \code{p4 > 1} are errors and return \code{NaN}.
  
  If \code{type.p.1.2 == "c-d"}, \code{p1 >= p2} is an error and returns 
  \code{NaN}.
  
  If \code{type.p.1.2 == "l-s"}, \code{p2 <= 0} is an error and returns 
  \code{NaN}.
}
\description{
Parameter conversion for different parameterizations for the BMT 
  distribution, with \code{p3} and \code{p4} tails weights (\eqn{\kappa_l} 
  and \eqn{\kappa_r}) or asymmetry-steepness parameters (\eqn{\zeta} and 
  \eqn{\xi}) and \code{p1} and \code{p2} domain (minimum and maximum) or 
  location-scale (mean and standard deviation) parameters.
}
\details{
The BMT coefficient of asymmetry \eqn{-1 < \zeta < 1} is 
  \deqn{\kappa_r - \kappa_l}
  
  The BMT coefficient of steepness \eqn{0 < \xi < 1} is \deqn{(\kappa_r + 
  \kappa_l - |\kappa_r - \kappa_l|) / (2 (1 -  |\kappa_r - \kappa_l|))} for 
  \eqn{|\kappa_r - \kappa_l| < 1}.
  
  The BMT distribution has mean \eqn{( d - c ) BMTmean(\kappa_l, \kappa_r) + 
  c} and standard deviation \eqn{( d - c ) BMTsd(\kappa_l, \kappa_r)}
  
  From these equations, we can go back and forth with each parameterization.
}
\examples{
# BMT on [0,1] with left tail weight equal to 0.25 and 
# right tail weight equal to 0.75
parameters <- BMTchangepars(0.25, 0.75, "t w")
parameters # Parameters of the BMT in the asymmetry-steepness parametrization

# BMT with mean equal to 0, standard deviation equal to 1, 
# asymmetry coefficient equal to 0.5 and 
# steepness coefficient equal to 0.75
parameters <- BMTchangepars(0.5, 0.5, "a-s", 0, 1, "l-s")
parameters # Parameters of the BMT in the tail weight and domain parametrization
}
\references{
Torres-Jimenez, C. J. (2018), \emph{The BMT Item Response Theory 
  model: A new skewed distribution family with bounded domain and an IRT 
  model based on it}, PhD thesis, Doctorado en ciencias - Estadistica, 
  Universidad Nacional de Colombia, Sede Bogota.
}
\seealso{
\code{\link{BMT}} for the BMT density, distribution, quantile 
  function and random deviates.
}
\author{
Camilo Jose Torres-Jimenez [aut,cre] \email{cjtorresj@unal.edu.co} 
  and Alvaro Mauricio Montenegro Diaz [ths]
}
