% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ApiGetDMCs.R
\name{ApiGetDMCs}
\alias{ApiGetDMCs}
\title{Get TOPK=500 DMCs and non-DMCs using moderated-t test}
\usage{
ApiGetDMCs(betaValue, TOPK = 500, tumorNum = NULL,
  filterProbes = FALSE, userProbes = NULL)
}
\arguments{
\item{betaValue}{A matrix from TCGA array data}

\item{TOPK}{An integer number, default 500. Number of DMCs/non-DMCs.}

\item{tumorNum}{A postive number, First tumorNum columns in betaValue
are tumor samples. If tumorNum is NULL, first half of
columns are considered as tumor samples,}

\item{filterProbes}{Logistic. defalut is FALSE. The code use all probes in betaValue.
If TRUE,
you can use default good probes provided in our code.
you can also provide your good probes in userProbes.}

\item{userProbes}{A number list. The row numbers in betaValue.
                    These rows are considered as good probes.
return DMCs        (TOPK DMCs and TOPK non-DMCs row index in betaValue)}
}
\description{
Get TOPK=500 DMCs and non-DMCs using moderated-t test
}
\note{
User can provide the good probes indexes (row number)
                   to filter the probes.
                   A global variable goodProbes are used in this function.
                   goodProbes: probes with SNPs at the CpG or single base
                   extension sites, and corss-reative probes are removed.
                   More details see the reference paper.
}
