% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fullSampler.R
\name{fullSampler}
\alias{fullSampler}
\title{Sampling xi and alpha (tumor purity)}
\usage{
fullSampler(y, z, mstates, xprior = NULL, maxit = 1000,
  burnin = maxit, xpar = FALSE, n_ab0 = NULL, alp0 = NULL,
  xbar0 = NULL, trace = FALSE, verbose = FALSE)
}
\arguments{
\item{y}{A matrix, observed pure normal samples}

\item{z}{A matrix, observed mixed tumor samples}

\item{mstates}{A matrix, hyper/hypo of dataset}

\item{xprior}{A matrix, prior knowledge about purity}

\item{maxit}{A number, maximum iteraction}

\item{burnin}{A number, "burn-in" sample}

\item{xpar}{Logistic, default is FALSE}

\item{n_ab0}{initial value of n_ab}

\item{alp0}{initial value of alpha}

\item{xbar0}{initial value of xbar}

\item{trace}{Logisitc, check the values in code, default is FALSE}

\item{verbose}{Logistic, output the message,default is FALSE}
}
\value{
x_bar    x_mode,
x_last   x2
x_sample x_sample
xpar     xprior2,
nab      n_ab2,
alp      alp2
}
\description{
Sampling xi and alpha (tumor purity)
}
