% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BTdecayLassoF.R
\name{BTdecayLassoF}
\alias{BTdecayLassoF}
\title{Bradley-Terry Model with Exponential Decayed weighted likelihood and Adaptive Lasso with a given penalty rate}
\usage{
BTdecayLassoF(
  dataframe,
  ability,
  penalty,
  decay.rate = 0,
  fixed = 1,
  thersh = 1e-05,
  max = 100,
  iter = 100
)
}
\arguments{
\item{dataframe}{Generated using \code{\link{BTdataframe}} given raw data.}

\item{ability}{A column vector of teams ability, the last row is the home parameter. It can be generated using \code{\link{BTdataframe}} given raw data.
The row number is consistent with the team's index shown in dataframe. It can be generated using \code{\link{BTdataframe}} given raw data.}

\item{penalty}{The amount of Lasso penalty induced (1-s/max(s)) where is the sum of Lasso penalty part.}

\item{decay.rate}{The exponential decay rate. Usually ranging from (0, 0.01), A larger decay rate weights more
importance to most recent matches and the estimated parameters reflect more on recent behaviour.}

\item{fixed}{A teams index whose ability will be fixed as 0. The worstTeam's index
can be generated using \code{\link{BTdataframe}} given raw data.}

\item{thersh}{Threshold for convergence}

\item{max}{Maximum weight for \eqn{w_{ij}} (weight used for Adaptive Lasso)}

\item{iter}{Number of iterations used in L-BFGS-B algorithm.}
}
\value{
The list with class "BTF" contains estimated abilities and other parameters.
\item{ability}{Estimated ability scores}
\item{df}{Degree of freedom (number of distinct \eqn{\mu})}
\item{penalty}{Amount of Lasso Penalty}
\item{decay.rate}{Exponential decay rate}
\item{lambda}{Corresponding Lasso lambda given penalty rate}
}
\description{
This function provides a method to computed the estimated abilities and lambda given an intuitive fixed Lasso penalty rate.
Since in Lasso method, the selection of lambda varies a lot with respect to different datasets. We can keep the consistency of
amount of Lasso penalty induced in different datasets from different period by setting a fixed Lasso penalty rate "penalty".
Please refer to \code{\link{BTdecayLasso}} for the definition of "penalty" and its relationship with "lambda".
}
\details{
The estimated ability given fixed penalty \eqn{p = 1- s/\max(s)} where s is the sum of Lasso penalty part.
When p = 0, this model is reduced to a standard Bradley-Terry Model.
When p = 1, all ability scores are shrinking to 0.

The parameter "penalty" should be ranging from 0.01 to 0.99 due to the iteration's convergent error.

summary() function can be applied to view the outputs.
}
\references{
Masarotto, G. and Varin, C.(2012) The Ranking Lasso and its Application to Sport Tournaments. 
*The Annals of Applied Statistics* **6** 1949--1970.

Zou, H. (2006) The adaptive lasso and its oracle properties. 
*J.Amer.Statist.Assoc* **101** 1418--1429.
}
\seealso{
\code{\link{BTdataframe}} for dataframe initialization, \code{\link{BTdecayLasso}} for detailed description
}
