% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vsb.R
\name{vsb}
\alias{vsb}
\title{Variance estimator for spatially balanced samples}
\usage{
vsb(probs, ys, xs, k = 3L, type = "kdtree2", bucketSize = 40)
}
\arguments{
\item{probs}{A vector of length n with inclusion probabilities.}

\item{ys}{A vector of length n containing the target variable.}

\item{xs}{An n by p matrix of (standardized) auxiliary variables.}

\item{k}{The number of neighbours to construct the means around.}

\item{type}{The method used in finding nearest neighbours.
Must be one of \code{"kdtree0"}, \code{"kdtree1"}, \code{"kdtree2"}, and
\code{"notree"}.}

\item{bucketSize}{The maximum size of the terminal nodes in the k-d-trees.}
}
\value{
The variance estimate.
}
\description{
Variance estimator of HT estimator of population total.
}
\details{
If \code{k = 0L}, the variance estimate is constructed by using all units that
have the minimum distance.

If \code{k > 0L}, the variance estimate is constructed by using the \code{k} closest
units. If multiple units are located on the border, all are used.
}
\section{k-d-trees}{

The \code{type}s "kdtree" creates k-d-trees with terminal node bucket sizes
according to \code{bucketSize}.

\itemize{
\item{"kdtree0"} creates a k-d-tree using a median split on alternating variables.
\item{"kdtree1"} creates a k-d-tree using a median split on the largest range.
\item{"kdtree2"} creates a k-d-tree using a sliding-midpoint split.
\item{"notree"} does a naive search for the nearest neighbour.
}
}

\examples{
\dontrun{
set.seed(12345);
N = 1000;
n = 100;
prob = rep(n/N, N);
x = matrix(runif(N * 2), ncol = 2);
y = runif(N);
s = lpm2(prob, x);
vsb(prob[s], y[s], x[s, ]);
vsb(prob[s], y[s], x[s, ], 0L);
}

}
\references{
Grafström, A., & Schelin, L. (2014).
How to select representative samples.
Scandinavian Journal of Statistics, 41(2), 277-290.
}
\seealso{
Other measure: 
\code{\link{sb}()}
}
\concept{measure}
