% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barcodes.eval.R
\name{barcodes.eval}
\alias{barcodes.eval}
\title{Barcodes Evaluation}
\usage{
barcodes.eval(barcode1, barcode2, kmer1 = kmer1, kmer2 = kmer2)
}
\arguments{
\item{barcode1}{object of class "DNAbin" based on barcode1, which contains taxon information.}

\item{barcode2}{object of class "DNAbin" based on barcode2, which contains taxon information.}

\item{kmer1}{a numeric to indicate the length of kmer1 for barcode1, the optimal kmer could be found by the function
optimize.kmer() before running this function.}

\item{kmer2}{a numeric to indicate the length of kmer2 for barcode2, see above.}
}
\value{
a list containing p_value of prop.test(), and so on.
}
\description{
Evaluate two barcodes using species identification success rate criteria.
}
\examples{

data(TibetanMoth) 
barcode1<-as.DNAbin(as.character(TibetanMoth[1:30,]))
barcode2<-barcode1
b.eval<-barcodes.eval(barcode1,barcode2,kmer1=1,kmer2=3)
b.eval
}
\references{
zhangab2008 (at) mail. cnu. edu. cn.
}
\seealso{
prop.test()
}
\author{
Ai-bing ZHANG, PhD. CNU, Beijing, CHINA.
}
\keyword{barcodes.eval}
