% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pull.R
\name{pull.TidySet}
\alias{pull.TidySet}
\alias{pull_set}
\alias{pull_element}
\alias{pull_relation}
\title{Pull from a TidySet}
\usage{
\method{pull}{TidySet}(.data, var = -1, name = NULL, ...)

pull_set(.data, var = -1, name = NULL, ...)

pull_element(.data, var = -1, name = NULL, ...)

pull_relation(.data, var = -1, name = NULL, ...)
}
\arguments{
\item{.data}{The TidySet object}

\item{var}{The literal variable name, a positive integer or a negative
integer column position.}

\item{name}{Column used to name the output.}

\item{...}{Currently not used.}
}
\value{
A TidySet object
}
\description{
Use pull to extract the columns of a TidySet object. You can use activate
with filter or use the specific function. The S3 method filters using all
the information on the TidySet.
}
\examples{
relations <- data.frame(
    sets = c(rep("a", 5), "b", rep("a2", 5), "b2"),
    elements = rep(letters[seq_len(6)], 2),
    fuzzy = runif(12)
)
a <- tidySet(relations)
a <- mutate_element(a, type = c(rep("Gene", 4), rep("lncRNA", 2)))
pull(a, type)
# Equivalent to pull_relation
b <- activate(a, "relations")
pull_relation(b, elements)
pull_element(b, elements)
# Filter element
pull_element(a, type)
# Filter sets
pull_set(a, sets)
}
\seealso{
\code{\link[dplyr:pull]{dplyr::pull()}} and \code{\link[=activate]{activate()}}

Other methods: 
\code{\link{TidySet-class}},
\code{\link{activate}()},
\code{\link{add_column}()},
\code{\link{add_relation}()},
\code{\link{arrange.TidySet}()},
\code{\link{cartesian}()},
\code{\link{complement}()},
\code{\link{complement_element}()},
\code{\link{complement_set}()},
\code{\link{element_size}()},
\code{\link{elements}()},
\code{\link{filter.TidySet}()},
\code{\link{group}()},
\code{\link{group_by.TidySet}()},
\code{\link{incidence}()},
\code{\link{intersection}()},
\code{\link{is.fuzzy}()},
\code{\link{is_nested}()},
\code{\link{move_to}()},
\code{\link{mutate.TidySet}()},
\code{\link{nElements}()},
\code{\link{nRelations}()},
\code{\link{nSets}()},
\code{\link{name_elements<-}()},
\code{\link{name_sets}()},
\code{\link{name_sets<-}()},
\code{\link{power_set}()},
\code{\link{relations}()},
\code{\link{remove_column}()},
\code{\link{remove_element}()},
\code{\link{remove_relation}()},
\code{\link{remove_set}()},
\code{\link{rename_elements}()},
\code{\link{rename_set}()},
\code{\link{select.TidySet}()},
\code{\link{set_size}()},
\code{\link{sets}()},
\code{\link{subtract}()},
\code{\link{union}()}
}
\concept{methods}
