% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/set.R
\name{sets}
\alias{sets}
\alias{sets<-}
\alias{sets,TidySet-method}
\alias{sets<-,TidySet-method}
\alias{replace_sets}
\alias{nSets,TidySet,missing-method}
\alias{nSets,TidySet,logical-method}
\title{Sets of the TidySet}
\usage{
sets(object)

sets(object) <- value

\S4method{sets}{TidySet}(object)

\S4method{sets}{TidySet}(object) <- value

replace_sets(object, value)

\S4method{nSets}{TidySet,missing}(object)

\S4method{nSets}{TidySet,logical}(object, all)
}
\arguments{
\item{object}{A \code{TidySet} object.}

\item{value}{Modification of the sets.}

\item{all}{A logical value whether it should return all sets or only those present.}
}
\value{
A \code{data.frame} with information from the sets.
}
\description{
Given TidySet retrieve the sets or substitute them.
}
\section{Methods (by class)}{
\itemize{
\item \code{sets(TidySet)}: Retrieve the sets information

\item \code{sets(TidySet) <- value}: Modify the sets information

\item \code{nSets(object = TidySet, all = missing)}: Return the number of sets

\item \code{nSets(object = TidySet, all = logical)}: Return the number of sets

}}
\examples{
TS <- tidySet(list(A = letters[1:5], B = letters[2:10]))
sets(TS)
sets(TS) <- data.frame(sets = c("B", "A"))
TS2 <- replace_sets(TS, data.frame(sets = c("A", "B", "C")))
sets(TS2)
nSets(TS)
nSets(TS2)
}
\seealso{
\code{\link[=nSets]{nSets()}}

Other slots: 
\code{\link{elements}()},
\code{\link{relations}()}

Other methods: 
\code{\link{TidySet-class}},
\code{\link{activate}()},
\code{\link{add_column}()},
\code{\link{add_relation}()},
\code{\link{arrange.TidySet}()},
\code{\link{cartesian}()},
\code{\link{complement}()},
\code{\link{complement_element}()},
\code{\link{complement_set}()},
\code{\link{element_size}()},
\code{\link{elements}()},
\code{\link{filter.TidySet}()},
\code{\link{group}()},
\code{\link{group_by.TidySet}()},
\code{\link{incidence}()},
\code{\link{intersection}()},
\code{\link{is.fuzzy}()},
\code{\link{is_nested}()},
\code{\link{move_to}()},
\code{\link{mutate.TidySet}()},
\code{\link{nElements}()},
\code{\link{nRelations}()},
\code{\link{nSets}()},
\code{\link{name_elements<-}()},
\code{\link{name_sets}()},
\code{\link{name_sets<-}()},
\code{\link{power_set}()},
\code{\link{pull.TidySet}()},
\code{\link{relations}()},
\code{\link{remove_column}()},
\code{\link{remove_element}()},
\code{\link{remove_relation}()},
\code{\link{remove_set}()},
\code{\link{rename_elements}()},
\code{\link{rename_set}()},
\code{\link{select.TidySet}()},
\code{\link{set_size}()},
\code{\link{subtract}()},
\code{\link{union}()}
}
\concept{methods}
\concept{slots}
