% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_results.R
\name{process_results}
\alias{process_results}
\title{Helper function for processing results}
\usage{
process_results(
  name,
  f2.dist,
  ci.type = c("quantile", "HPD"),
  level,
  get.dist = FALSE
)
}
\arguments{
\item{name}{A character string denoting the type of method used to calculate the interval.}

\item{f2.dist}{A vector of samples for the F2 parameter or f2 statistic.}

\item{ci.type}{The type of confidence, or credible, interval to return. The option \code{quantile} returns sample quantile based intervals, while the option \code{HPD} returns intervals based on highest density regions.}

\item{level}{The confidence level or probability associated with the confidence or credible interval, respectively. Must be a value between 0 and 1.}

\item{get.dist}{logical; if \code{TRUE}, returns the samples of the distribution.}
}
\value{
The function returns a data object of class dis_data.
}
\description{
This function helps process the final results for the different f2 functions (e.g., f2bayes).
}
\examples{
### dis_data comes loaded with the package
out1 <- f2bayes(dis_data, prob = 0.9, B = 1000, get.dist = TRUE)

out2 <- process_results("bayes", out1$f2.dist, level = 0.9)

### out1 and out2 should contain the results for the info and intervals

}
