% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{nsCrossdist3d}
\alias{nsCrossdist3d}
\title{Calculate coordinate-specific cross-distance matrices, only for nearest neighbors
and store in an array}
\usage{
nsCrossdist3d(
  coords,
  predCoords,
  P_nID,
  scale_factor = NULL,
  isotropic = FALSE
)
}
\arguments{
\item{coords}{N x d matrix; contains the x-y coordinates of stations.}

\item{predCoords}{M x d matrix}

\item{P_nID}{N x k matrix; contains indices of nearest neighbors.}

\item{scale_factor}{Scalar; optional argument for re-scaling the distances.}

\item{isotropic}{Logical; indicates whether distances should be calculated
separately for each coordinate dimension (FALSE) or simultaneously for all
coordinate dimensions (TRUE). \code{isotropic = FALSE} can only be used for
two-dimensional coordinate systems.}
}
\value{
Arrays with nearest neighbor distances in each coordinate 
direction. When the spatial dimension d > 2, dist1_3d contains squared
Euclidean distances, and dist2_3d and dist12_3d are empty.
}
\description{
\code{nsCrossdist3d} generates and returns new 3-dimensional arrays containing
the former dist1_sq, dist2_s1, and dist12 matrices, but
only as needed for the k nearest-neighbors of each location.
these 3D matrices (dist1_3d, dist2_3d, and dist12_3d)
are used in the new implementation of calculateAD_ns().
}
\examples{
# Generate some coordinates and neighbors
coords <- cbind(runif(100),runif(100))
predCoords <- cbind(runif(200),runif(200))
P_nID <- FNN::get.knnx(coords, predCoords, k = 10)$nn.index # Prediction NN
# Calculate distances
Pdist <- nsCrossdist3d(coords, predCoords, P_nID)

}
