% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpPolar-functions.R
\name{Xlinear}
\alias{Xlinear}
\title{Compute the linear index \eqn{X'\theta}}
\usage{
Xlinear(betavec, dataX)
}
\arguments{
\item{betavec}{A numeric vector of regression coefficients of length \eqn{p}.}

\item{dataX}{A numeric matrix of predictors with \eqn{n} rows (observations)
and \eqn{p} columns (features).}
}
\value{
A numeric vector of length \eqn{n}, representing \eqn{X'\theta}.
}
\description{
A \pkg{nimble} function that calculates the \eqn{X'\theta}
for each observation, given matrix \code{dataX} and index
vector \code{betavec}. This serves as a basic building block for
single-index or regression-type models implemented in \pkg{nimble}.
}
\details{
For a dataset with \eqn{n} observations and \eqn{p} predictors, the function
computes linear projection, \eqn{X'\theta}.
The implementation uses explicit loops to ensure full compatibility with
\pkg{nimble}'s compiled execution framework.
}
\seealso{
\code{\link{gpPolar}}, \code{\link{gpPolarHigh}}, \code{\link{predict.bsimGp}}
}
