% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{simulateData}
\alias{simulateData}
\title{simulateData}
\usage{
simulateData(
  n_patients,
  dose_levels,
  sd,
  mods,
  n_sim = 1000,
  true_model = NULL,
  dr_means = NULL
)
}
\arguments{
\item{n_patients}{Vector containing number of patients as a numerical
value per dose-group.}

\item{dose_levels}{Vector containing the different dosage levels.}

\item{sd}{Standard deviation on patient level.}

\item{mods}{An object of class "Mods" as specified in the DoseFinding package.}

\item{n_sim}{Number of simulations to be performed,
Default is 1000}

\item{true_model}{Default value is NULL.
Assumed true underlying model. Provided via a String. e.g. "emax".
In case of NULL, all dose-response models, included in the mods input parameter will be used.}

\item{dr_means}{a vector, with information about assumed effects per dose group. Default NULL.}
}
\value{
A list object, containing patient level simulated data for all assumed true models.
Also providing information about simulation iteration, patient number as well as dosage levels.
}
\description{
Function to simulate patient level data for a normally distributed endpoint
}
\examples{
models <- DoseFinding::Mods(linear      = NULL,
                            linlog      = NULL,
                            emax        = c(0.5, 1.2),
                            exponential = 2, 
                            doses       = c(0, 0.5, 2,4, 8),
                            maxEff      = 6)
dose_levels <- c(0, 0.5, 2,4, 8)
sd          <- 12
n_patients  <- c(40, 60, 60, 60, 60)

sim_data <- simulateData(n_patients  = n_patients,
                         dose_levels = dose_levels,
                         sd          = sd,
                         mods        = models,
                         n_sim       = 100)

head(sim_data)

}
