/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evolution.tree.NodeRef;
import dr.evomodel.bigfasttree.thorney.ConstrainableTreeOperator;
import dr.evomodel.operators.AbstractTreeOperator;
import dr.evomodel.tree.TreeModel;
import dr.math.MathUtils;

public class WilsonBalding
extends AbstractTreeOperator
implements ConstrainableTreeOperator {
    private TreeModel tree = null;

    public WilsonBalding(TreeModel treeModel, double d) {
        this.tree = treeModel;
        this.setWeight(d);
    }

    @Override
    public double doOperation(TreeModel treeModel) {
        double d = this.proposeTree(treeModel);
        int n = treeModel.getExternalNodeCount();
        if (treeModel.getExternalNodeCount() != n) {
            int n2 = treeModel.getExternalNodeCount();
            throw new RuntimeException("Lost some tips in modified SPR! (" + n + "-> " + n2 + ")");
        }
        return d;
    }

    @Override
    public double doOperation() {
        return this.doOperation(this.tree);
    }

    public double proposeTree(TreeModel treeModel) {
        NodeRef nodeRef;
        int n = treeModel.getNodeCount();
        do {
            nodeRef = treeModel.getNode(MathUtils.nextInt(n));
        } while (treeModel.getRoot() == nodeRef);
        NodeRef nodeRef2 = treeModel.getParent(nodeRef);
        NodeRef nodeRef3 = treeModel.getNode(MathUtils.nextInt(n));
        NodeRef nodeRef4 = treeModel.getParent(nodeRef3);
        while (nodeRef4 != null && treeModel.getNodeHeight(nodeRef4) <= treeModel.getNodeHeight(nodeRef) || nodeRef == nodeRef3) {
            nodeRef3 = treeModel.getNode(MathUtils.nextInt(n));
            nodeRef4 = treeModel.getParent(nodeRef3);
        }
        if (nodeRef3 == treeModel.getRoot() || nodeRef2 == treeModel.getRoot()) {
            return Double.NEGATIVE_INFINITY;
        }
        if (nodeRef4 == nodeRef2 || nodeRef3 == nodeRef2 || nodeRef4 == nodeRef) {
            return Double.NEGATIVE_INFINITY;
        }
        NodeRef nodeRef5 = this.getOtherChild(treeModel, nodeRef2, nodeRef);
        NodeRef nodeRef6 = treeModel.getParent(nodeRef2);
        double d = Math.max(treeModel.getNodeHeight(nodeRef), treeModel.getNodeHeight(nodeRef3));
        double d2 = treeModel.getNodeHeight(nodeRef4) - d;
        double d3 = d + MathUtils.nextDouble() * d2;
        double d4 = Math.max(treeModel.getNodeHeight(nodeRef), treeModel.getNodeHeight(nodeRef5));
        double d5 = treeModel.getNodeHeight(nodeRef6) - d4;
        double d6 = d2 / Math.abs(d5);
        treeModel.beginTreeEdit();
        if (nodeRef3 == treeModel.getRoot()) {
            treeModel.removeChild(nodeRef2, nodeRef5);
            treeModel.removeChild(nodeRef6, nodeRef2);
            treeModel.addChild(nodeRef2, nodeRef3);
            treeModel.addChild(nodeRef6, nodeRef5);
            treeModel.setRoot(nodeRef2);
        } else if (nodeRef2 == treeModel.getRoot()) {
            treeModel.removeChild(nodeRef4, nodeRef3);
            treeModel.removeChild(nodeRef2, nodeRef5);
            treeModel.addChild(nodeRef2, nodeRef3);
            treeModel.addChild(nodeRef4, nodeRef2);
            treeModel.setRoot(nodeRef5);
        } else {
            treeModel.removeChild(nodeRef4, nodeRef3);
            treeModel.removeChild(nodeRef2, nodeRef5);
            treeModel.removeChild(nodeRef6, nodeRef2);
            treeModel.addChild(nodeRef2, nodeRef3);
            treeModel.addChild(nodeRef4, nodeRef2);
            treeModel.addChild(nodeRef6, nodeRef5);
        }
        treeModel.setNodeHeight(nodeRef2, d3);
        treeModel.endTreeEdit();
        return Math.log(d6);
    }

    public double getMinimumAcceptanceLevel() {
        return 0.01;
    }

    public String getPerformanceSuggestion() {
        return "";
    }

    @Override
    public String getOperatorName() {
        return "wilsonBalding(" + this.tree.getId() + ")";
    }
}

