% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflowfunction.R
\name{CompareResultJI}
\alias{CompareResultJI}
\title{Compare Biclustering Results using Jaccard Index}
\usage{
CompareResultJI(BCresult1, BCresult2 = NULL, type = "both", plot = TRUE)
}
\arguments{
\item{BCresult1}{A S4 Biclust object. If only this input Biclust object is given, the biclusters of this single result will be compared.}

\item{BCresult2}{A second S4 Biclust object to which \code{BCresult1} should be compared. (default=\code{NULL})}

\item{type}{Of which dimension should the Jaccard Index be computed? Can be \code{"row"}, \code{"col"} or \code{"both"} (default).}

\item{plot}{Logical value if plot should be outputted (default=\code{TRUE}).}
}
\value{
A list containing
\itemize{
\item \code{SimMat}: The JI Similarity Matrix between the compared biclusters.
\item \code{MaxSim}: A list containing the maximum values on each row (\code{BCResult1}) and each column (\code{BCResult2}).
}
}
\description{
Creates a heatmap and returns a similarity matrix of the Jaccard Index (Row, Column or both dimensions) in order to compare 2 different biclustering results or compare the biclusters of a single result.
}
\details{
The Jaccard Index between two biclusters is calculated as following:
\deqn{JI(BC1,BC2) = \frac{(m_1+m_2-m_{12})}{m_{12}}}
in which
\itemize{
\item \code{type="row"} or \code{type="col"}   
\itemize{
\item \eqn{m_1=} Number of rows/columns of BC1
\item \eqn{m_2=} Number of rows/columns of BC2
\item \eqn{m_{12}=} Number of rows/columns of union of row/column membership of BC1 and BC2
}
\item \code{type="both"}
\itemize{
\item \eqn{m_1=} Size of BC1 (rows times columns)
\item \eqn{m_2=} Size of BC2 (rows times columns)
\item \eqn{m_{12}= m_1+m_2 -} size of overlapping BC of BC1 and BC2 
}
}
}
\examples{
\dontrun{
data <- matrix(sample(c(0,1),100*100,replace=TRUE,prob=c(0.9,0.1)),nrow=100,ncol=100)
data[1:10,1:10] <- 1 # BC1
data[11:20,11:20] <- 1 # BC2
data[21:30,21:30] <- 1 # BC3
data <- data[sample(1:nrow(data),nrow(data)),sample(1:ncol(data),ncol(data))]

# Result 1
result1 <- bibit(data,minr=5,minc=5)
result1

# Result 2
result2 <- bibit(data,minr=2,minc=2)
result2

## Compare all BC's of Result 1 ##
Sim1 <- CompareResultJI(BCresult1=result1,type="both")
Sim1$SimMat

## Compare BC's of Result 1 and 2 ##
Sim12 <- CompareResultJI(BCresult1=result1,BCresult2=result2,type="both",plot=FALSE)
str(Sim12)
}
}
\author{
Ewoud De Troyer
}

