% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_pa.R
\name{est_up}
\alias{est_up}
\title{Title}
\usage{
est_up(E, k = 5)
}
\arguments{
\item{E}{the observation matrix such that each of its row has a block structure correlation matrix Sigma wich has a low rank once its diagonal is removed.}

\item{k}{the rank of the correlation matrix of \code{E} once its diagonal has been removed}
}
\value{
an approximation of the correlation matrix of \code{E} with its diagonal removed
}
\description{
Title
}
\examples{
n <- 30
q <- 100
Sigma <- Simu_Sigma(q = q, diag = FALSE, equal = TRUE)
Matrix::image(Sigma)
E <- matrix(rnorm(n * q), ncol = q) \%*\% chol(as.matrix(Sigma))
k <- 5
v_up <- est_up(E, k = k)
}
