% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BP_DetectBackground.R
\name{BP_DetectBackground}
\alias{BP_DetectBackground}
\title{Detects the background color of an image}
\usage{
BP_DetectBackground(bone, analysis = 1, show.plot = TRUE)
}
\arguments{
\item{bone}{The bone image to be used}

\item{analysis}{The name or rank of analysis}

\item{show.plot}{should plot is shown ?}
}
\value{
The orignial bone object with a new attribute for background color
}
\description{
Detects the background color of an image.
}
\details{
BP_DetectBackground detects the background color of an image
}
\examples{
\dontrun{
# Not run:
 bone <- BP_OpenImage()
 bone <- BP_DetectBackground(bone=bone)
 bone <- BP_DetectForeground(bone=bone)
 plot(bone)
}
}
\seealso{
Other BoneProfileR: 
\code{\link{BP_AutoFit}()},
\code{\link{BP_ChooseBackground}()},
\code{\link{BP_ChooseCenter}()},
\code{\link{BP_ChooseForeground}()},
\code{\link{BP_DetectCenters}()},
\code{\link{BP_DetectForeground}()},
\code{\link{BP_DuplicateAnalysis}()},
\code{\link{BP_EstimateCompactness}()},
\code{\link{BP_FitBayesianCompactness}()},
\code{\link{BP_FitBayesianPeriodicCompactness}()},
\code{\link{BP_FitMLCompactness}()},
\code{\link{BP_FitMLPeriodicCompactness}()},
\code{\link{BP_FitMLRadialCompactness}()},
\code{\link{BP_GetFittedParameters}()},
\code{\link{BP_ListAnalyses}()},
\code{\link{BP_LnLCompactness}()},
\code{\link{BP_OpenImage}()},
\code{\link{BP_Report}()},
\code{\link{Erinaceus_europaeus}},
\code{\link{plot.BoneProfileR}()},
\code{\link{summary.BoneProfileR}()}
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
\concept{BoneProfileR}
