% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{download}
\alias{download}
\title{Download file from browndog}
\usage{
download(url, file, token, timeout = 60)
}
\arguments{
\item{url}{the url of the file to download}

\item{file}{the filename}

\item{token}{Brown Dog access token}

\item{timeout}{timeout number of seconds to wait for file (default 60)}
}
\value{
the name of file if successfull or NA if not.
}
\description{
This will download a file, if a 404 is returned it will wait until
the file is available. If the file is still not available after
timeout tries, it will return NA. If the file is downloaded it will
return the name of the file
}
\examples{
\dontrun{
key <- get_key("https://bd-api-dev.ncsa.illinois.edu", "your email", "password")
token <- get_token("https://bd-api-dev.ncsa.illinois.edu", key)
download("https://bd-api-dev.ncsa.illinois.edu", "vdc.csv", token)
}
}
